import { jsx, jsxs } from "react/jsx-runtime";
import { C as Card } from "./card-DBOrqCcU.js";
import { g as getPageSection, S as Section, a as getPropertyArray } from "./section-DVceEJ6r.js";
import { k as getColorWithOpacity } from "./utils-Dq7odfJT.js";
import { usePage } from "@inertiajs/react";
import { DynamicIcon } from "lucide-react/dynamic";
import "react";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "lucide-react";
import "./use-lang-44ndmTOc.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./input-BPdrsFAc.js";
import "axios";
import "sonner";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./textarea-M8ToDCeU.js";
import "./inertia-BtwbgBI3.js";
import "./icon-picker-dialog-kwu88Bla.js";
import "./icon-picker-CUJAUhoK.js";
import "./debounce-ZFxqVthq.js";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "@tanstack/react-table";
import "./table-page-size-CjbVFJnO.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "clsx";
import "tailwind-merge";
const Overview = () => {
  const { props } = usePage();
  const overviewSection = getPageSection(props.page, "overview");
  return /* @__PURE__ */ jsx(Section, { customize: props.customize, pageSection: overviewSection, containerClass: "py-20", contentClass: "text-center", children: /* @__PURE__ */ jsx("div", { className: "relative grid grid-cols-1 gap-7 sm:grid-cols-2 md:grid-cols-4", children: getPropertyArray(overviewSection).map((stat, index) => {
    return /* @__PURE__ */ jsxs(
      Card,
      {
        className: "bg-secondary-lighter rounded-3xl border-none px-6 py-10 !shadow-none md:py-12",
        style: { backgroundColor: getColorWithOpacity(stat.color, 0.1) },
        children: [
          /* @__PURE__ */ jsx(
            "div",
            {
              className: "bg-secondary-foreground mx-auto flex h-14 w-14 items-center justify-center rounded-full",
              style: { backgroundColor: getColorWithOpacity(stat.color, 1) },
              children: /* @__PURE__ */ jsx(DynamicIcon, { name: stat.icon, className: "h-8 w-8 text-white" })
            }
          ),
          /* @__PURE__ */ jsxs("div", { className: "mt-4 space-y-2", children: [
            /* @__PURE__ */ jsx("h3", { className: "text-4xl font-semibold md:text-[44px]", children: stat.count }),
            /* @__PURE__ */ jsx("p", { className: "text-muted-foreground mt-6", children: stat.title })
          ] })
        ]
      },
      `element-${index}`
    );
  }) }) });
};
export {
  Overview as default
};
